//Lab 05:Investigate stability of a system with relay control using describing function.
//scilab - 6.0.0
// Operating System : Windows 10, 64-bit

//------------------------------------------------------------------
close;
clc;
clear;
//------------------------------------------------------------------

// System Decription
s=poly(0,'s');
num=5;
den=(s+1)*(0.1*s+1)^2;
g=syslin('c',num/den)

//Nyquist plot of the system
nyquist(g)
title("Nyquist plot and describing function to determine limit cycle",'fontsize',4)
f=gca();
f.x_location = "origin"
f.y_location = "origin"
h=legend('');
h.visible = "off"
xset("color",2);

// Nyquist Plot of Describing Function for saturation nonlinearity. 
omegat=0.05:0.05:%pi;
a=sin(omegat);
k=1; 
Keq=4/%pi./a
DF_nyq=-1 ./Keq; 

plot(DF_nyq,zeros(1,length(DF_nyq)),'m-.','thickness',2)
exec .\figure_properties.sci; //custom script for setting figure properties
//zoom_rect([-0.8 -1.4 0.4 1.4])

//limit cycle point (Identified on plot)
plot(-0.2064, 0,'bo');

// Frequency and Magnitude of limit cycle
p=roots(den);
p=abs(p);
omega=sqrt(sum(1./p)/prod(1./p)) //rad/sec
set(gca(),"grid",[1 1])
xset('font size',2)
magn=prod(0.2064-roots(den))
